(function($){
	// Stick menu when reach top of page
	$(document).ready(function() {
	  if ($('.sticky_element'))
		  var stickyNavTop = $('.sticky_element').offset().top;

	  var stickyNav = function(){
		var scrollTop = $(window).scrollTop();

		if (scrollTop > stickyNavTop) { 
		  $('.sticky_element').addClass('sticky');
		} else {
		  $('.sticky_element').removeClass('sticky'); 
		}
	  };
	  stickyNav();
	  $(window).scroll(function() {
		stickyNav();
	  });
	});

	// Hide Header on on scroll down
	var didScroll;
	var lastScrollTop = 0;
	var delta = 5;
	var navbarHeight = $('.sticky_element').outerHeight();

	$(window).scroll(function(event){
		didScroll = true;
	});

	setInterval(function() {
		if (didScroll) {
			hasScrolled();
			didScroll = false;
		}
	}, 250);
	function hasScrolled() {
		var st = $(this).scrollTop();
		
		// Make sure they scroll more than delta
		if(Math.abs(lastScrollTop - st) <= delta)
			return;
		
		// If they scrolled down and are past the navbar, add class .nav-up.
		// This is necessary so you never see what is "behind" the navbar.
		if (st > lastScrollTop && st > navbarHeight){
			// Scroll Down
			$('.sticky_element').removeClass('nav-down').addClass('nav-up');
		} else {
			// Scroll Up
			if(st + $(window).height() < $(document).height()) {
				$('.sticky_element').removeClass('nav-up').addClass('nav-down');
			}
		}		
		lastScrollTop = st;
	}
})(jQuery);